/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndContainer;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.ProfileException;
import jade.imtp.leap.BackEndSkel;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.nio.NIOMediator;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.net.InetAddress;

public class BackEndDispatcher
implements NIOMediator,
BEConnectionManager,
Dispatcher {
    private static final long RESPONSE_TIMEOUT = 60000L;
    private long keepAliveTime;
    private long maxDisconnectionTime;
    private long expirationDeadline;
    private long lastReceivedTime;
    private boolean active = true;
    private boolean peerActive = true;
    private boolean connectionDropped = false;
    private JICPMediatorManager myMediatorManager;
    private String myID;
    private Properties myProperties;
    private BackEndContainer myContainer = null;
    private Connection myConnection = null;
    private Object writeLock = new Object();
    protected InputManager inpManager;
    protected OutputManager outManager;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private Object shutdownLock = new Object();

    public String getID() {
        return this.active ? this.myID : null;
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public void init(JICPMediatorManager mgr, String id, Properties props) throws ICPException {
        System.out.println("BackEndDispatcher starting...");
        this.myMediatorManager = mgr;
        this.myID = id;
        this.myProperties = props;
        this.maxDisconnectionTime = 600000L;
        try {
            this.maxDisconnectionTime = Long.parseLong(props.getProperty("max-disconnection-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.keepAliveTime = 60000L;
        try {
            this.keepAliveTime = Long.parseLong(props.getProperty("keep-alive-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        int inpCnt = 0;
        try {
            inpCnt = Integer.parseInt(props.getProperty("lastsid")) + 1 & 0xF;
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Next command for FE will have sessionID " + inpCnt);
        int lastSid = 15;
        try {
            lastSid = (byte)(Integer.parseInt(props.getProperty("outcnt")) - 1);
            if (lastSid < 0) {
                lastSid = 15;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        FrontEndStub st = new FrontEndStub(this);
        this.inpManager = new InputManager(inpCnt, st);
        BackEndSkel sk = this.startBackEndContainer(props);
        this.outManager = new OutputManager(lastSid, sk);
    }

    protected final BackEndSkel startBackEndContainer(Properties props) throws ICPException {
        try {
            String nodeName = this.myID.replace(':', '_');
            props.setProperty("container-name", nodeName);
            this.myContainer = new BackEndContainer(props, this);
            if (!this.myContainer.connect()) {
                throw new ICPException("BackEnd container failed to join the platform");
            }
            this.myID = this.myContainer.here().getName();
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "BackEndContainer " + this.myID + " successfully joined the platform");
            }
            return new BackEndSkel(this.myContainer);
        }
        catch (ProfileException pe) {
            pe.printStackTrace();
            throw new ICPException("Error creating profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                this.myContainer.shutDown();
            }
        }
    }

    public synchronized boolean handleIncomingConnection(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        this.checkTerminatedInfo(pkt);
        this.lastReceivedTime = System.currentTimeMillis();
        if (this.peerActive) {
            this.myConnection = c;
            this.updateConnectedState();
            this.inpManager.setConnection(this.myConnection);
            this.connectionDropped = false;
            return true;
        }
        this.kill();
        return false;
    }

    public synchronized void handleConnectionError(Connection c, Exception e) {
        if (this.active && this.peerActive && c == this.myConnection) {
            this.myConnection = null;
            this.updateConnectedState();
            this.inpManager.resetConnection();
            this.myLogger.log(Logger.WARNING, this.myID + ": Disconnection detected");
            this.setExpirationDeadline();
        }
    }

    public JICPPacket handleJICPPacket(JICPPacket p, InetAddress addr, int port) throws ICPException {
        throw new ICPException("Unexpected call");
    }

    public JICPPacket handleJICPPacket(Connection c, JICPPacket pkt, InetAddress addr, int port) throws ICPException {
        block9: {
            this.checkTerminatedInfo(pkt);
            this.lastReceivedTime = System.currentTimeMillis();
            JICPPacket reply = null;
            byte type = pkt.getType();
            switch (type) {
                case 30: {
                    System.out.println("DROP_DOWN received: " + pkt.getSessionID());
                    this.handleDropDown(c, pkt, addr, port);
                    break;
                }
                case 0: {
                    System.out.println("COMMAND received: " + pkt.getSessionID());
                    if (this.peerActive) {
                        reply = this.outManager.handleCommand(pkt);
                        break;
                    }
                    this.kill();
                    break;
                }
                case 2: {
                    System.out.println("KEEP_ALIVE received: " + pkt.getSessionID());
                    reply = this.outManager.handleKeepAlive(pkt);
                    break;
                }
                case 1: 
                case 100: {
                    System.out.println("RESPONSE/ERROR received: " + pkt.getSessionID());
                    this.inpManager.notifyIncomingResponseReceived(pkt);
                    break;
                }
                default: {
                    throw new ICPException("Unexpected packet type " + type);
                }
            }
            if (reply == null) break block9;
            try {
                this.writePacket(this.myConnection, reply);
                System.out.println("RESPONSE sent back: " + reply.getSessionID());
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, this.myID + ": Communication error sending back response. " + ioe);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePacket(Connection c, JICPPacket pkt) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            c.writePacket(pkt);
        }
    }

    public final void tick(long currentTime) {
        if (this.active && !this.connectionDropped) {
            if (this.keepAliveTime <= 0L || currentTime - this.lastReceivedTime > this.keepAliveTime + 60000L) {
                // empty if block
            }
            if (this.checkMaxDisconnectionTime(currentTime)) {
                this.myLogger.log(Logger.SEVERE, this.myID + ": Max disconnection time expired.");
                this.kill();
            }
        }
    }

    public FrontEnd getFrontEnd(BackEnd be, Properties props) throws IMTPException {
        return this.inpManager.getStub();
    }

    public void activateReplica(String addr, Properties props) throws IMTPException {
    }

    public void shutdown() {
        this.active = false;
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, this.myID + ": shutting down");
        }
        if (this.myID != null) {
            this.myMediatorManager.deregisterMediator(this.myID);
        }
        this.inpManager.shutdown();
        this.outManager.shutdown();
    }

    public synchronized byte[] dispatch(byte[] payload, boolean flush) throws ICPException {
        if (this.connectionDropped) {
            this.droppedToDisconnected();
            throw new ICPException("Connection dropped");
        }
        JICPPacket pkt = new JICPPacket(0, 0, payload);
        pkt = this.inpManager.dispatch(pkt, flush);
        return pkt.getData();
    }

    protected void handleDropDown(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        block4: {
            if (this.myLogger.isLoggable(Logger.INFO)) {
                this.myLogger.log(Logger.INFO, this.myID + ": DROP_DOWN request received.");
            }
            try {
                if (this.inpManager.isEmpty()) {
                    JICPPacket rsp = new JICPPacket(1, 0, null);
                    this.writePacket(c, rsp);
                    this.myConnection = null;
                    this.updateConnectedState();
                    this.inpManager.resetConnection();
                    this.connectionDropped = true;
                    break block4;
                }
                this.myLogger.log(Logger.WARNING, this.myID + ": DROP_DOWN request refused.");
                JICPPacket rsp = new JICPPacket(100, 0, null);
                this.writePacket(c, rsp);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, this.myID + ": Error writing DROP_DOWN response. " + e);
            }
        }
    }

    private void droppedToDisconnected() {
        this.connectionDropped = false;
        this.setExpirationDeadline();
        this.requestRefresh();
    }

    protected void requestRefresh() {
    }

    public synchronized boolean isConnected() {
        return this.myConnection != null;
    }

    private void updateConnectedState() {
        this.myProperties.put("connected", this.isConnected() ? "true" : "false");
    }

    private final synchronized void setExpirationDeadline() {
        this.expirationDeadline = System.currentTimeMillis() + this.maxDisconnectionTime;
    }

    private final synchronized boolean checkMaxDisconnectionTime(long currentTime) {
        return !this.isConnected() && currentTime > this.expirationDeadline;
    }

    private final boolean checkTerminatedInfo(JICPPacket pkt) {
        if ((pkt.getInfo() & 0x40) != 0) {
            this.peerActive = false;
            if (this.myLogger.isLoggable(Logger.INFO)) {
                this.myLogger.log(Logger.INFO, this.myID + ": Peer termination notification received");
            }
        }
        return this.peerActive;
    }

    protected class OutputManager {
        private JICPPacket lastResponse;
        private int lastSid;
        private BackEndSkel mySkel;

        OutputManager(int n, BackEndSkel s) {
            this.lastSid = n;
            this.mySkel = s;
        }

        void shutdown() {
        }

        final JICPPacket handleCommand(JICPPacket cmd) throws ICPException {
            JICPPacket reply = null;
            byte sid = cmd.getSessionID();
            if (sid == this.lastSid) {
                BackEndDispatcher.this.myLogger.log(Logger.WARNING, BackEndDispatcher.this.myID + ": Duplicated packet from BE: pkt-type=" + cmd.getType() + " info=" + cmd.getInfo() + " SID=" + sid);
                reply = this.lastResponse;
            } else {
                if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                    BackEndDispatcher.this.myLogger.log(Logger.FINE, BackEndDispatcher.this.myID + ": Received command " + sid + " from FE");
                }
                byte[] rspData = this.mySkel.handleCommand(cmd.getData());
                if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                    BackEndDispatcher.this.myLogger.log(Logger.FINER, BackEndDispatcher.this.myID + ": Command " + sid + " from FE served ");
                }
                reply = new JICPPacket(1, 0, rspData);
                reply.setSessionID(sid);
                this.lastSid = sid;
                this.lastResponse = reply;
            }
            return reply;
        }

        final JICPPacket handleKeepAlive(JICPPacket command) throws ICPException {
            if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINEST)) {
                BackEndDispatcher.this.myLogger.log(Logger.FINEST, BackEndDispatcher.this.myID + ": Keep-alive received");
            }
            return new JICPPacket(1, 0, null);
        }
    }

    protected class InputManager {
        private Connection myConnection;
        private boolean dispatching = false;
        private boolean waitingForFlush;
        private JICPPacket lastIncomingResponse;
        private int inpCnt;
        private FrontEndStub myStub;

        InputManager(int c, FrontEndStub s) {
            this.inpCnt = c;
            this.myStub = s;
        }

        FrontEndStub getStub() {
            return this.myStub;
        }

        void setConnection(Connection c) {
            this.myConnection = c;
            this.waitingForFlush = this.myStub.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetConnection() {
            BackEndDispatcher backEndDispatcher = BackEndDispatcher.this;
            synchronized (backEndDispatcher) {
                this.myConnection = null;
                BackEndDispatcher.this.notifyAll();
            }
        }

        final boolean isEmpty() {
            return !this.dispatching && this.myStub.isEmpty();
        }

        void shutdown() {
            this.resetConnection();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final JICPPacket dispatch(JICPPacket pkt, boolean flush) throws ICPException {
            this.dispatching = true;
            try {
                block10: {
                    JICPPacket jICPPacket;
                    if (!BackEndDispatcher.this.active) throw new ICPException("Unreachable");
                    if (this.myConnection == null) throw new ICPException("Unreachable");
                    if (this.waitingForFlush && !flush) {
                        throw new ICPException("Upsetting dispatching order");
                    }
                    this.waitingForFlush = false;
                    if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                        BackEndDispatcher.this.myLogger.log(Logger.FINE, BackEndDispatcher.this.myID + ": Sending command " + this.inpCnt + " to FE");
                    }
                    pkt.setSessionID((byte)this.inpCnt);
                    try {
                        this.lastIncomingResponse = null;
                        System.out.println("Sending command to FE " + pkt.getSessionID());
                        BackEndDispatcher.this.writePacket(this.myConnection, pkt);
                        System.out.println("Waiting for response from FE " + pkt.getSessionID());
                        pkt = this.waitForResponse(this.inpCnt, 60000L);
                        if (pkt == null) break block10;
                        System.out.println("Response received from FE " + pkt.getSessionID());
                        if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                            BackEndDispatcher.this.myLogger.log(Logger.FINER, BackEndDispatcher.this.myID + ": Response received from FE " + pkt.getSessionID());
                        }
                        if (pkt.getType() == 100) {
                            throw new ICPException(new String(pkt.getData()));
                        }
                        BackEndDispatcher.this.checkTerminatedInfo(pkt);
                        if (!BackEndDispatcher.this.peerActive) {
                            BackEndDispatcher.this.shutdown();
                        }
                        this.inpCnt = this.inpCnt + 1 & 0xF;
                        jICPPacket = pkt;
                    }
                    catch (IOException ioe) {
                        BackEndDispatcher.this.myLogger.log(Logger.WARNING, BackEndDispatcher.this.myID + ": " + ioe);
                        BackEndDispatcher.this.handleConnectionError(this.myConnection, ioe);
                        throw new ICPException("Dispatching error.", ioe);
                    }
                    Object var5_5 = null;
                    this.dispatching = false;
                    return jICPPacket;
                }
                BackEndDispatcher.this.myLogger.log(Logger.WARNING, BackEndDispatcher.this.myID + ": Response timeout expired");
                BackEndDispatcher.this.handleConnectionError(this.myConnection, null);
                throw new ICPException("Response timeout expired");
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.dispatching = false;
                throw throwable;
            }
        }

        private JICPPacket waitForResponse(int sessionID, long timeout) {
            try {
                while (this.lastIncomingResponse == null) {
                    BackEndDispatcher.this.wait(timeout);
                    if (this.lastIncomingResponse != null && this.lastIncomingResponse.getSessionID() != sessionID) {
                        BackEndDispatcher.this.myLogger.log(Logger.WARNING, BackEndDispatcher.this.myID + ": Duplicated response from FE: type=" + this.lastIncomingResponse.getType() + " info=" + this.lastIncomingResponse.getInfo() + " SID=" + this.lastIncomingResponse.getSessionID());
                        this.lastIncomingResponse = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {}
            return this.lastIncomingResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIncomingResponseReceived(JICPPacket rsp) {
            BackEndDispatcher backEndDispatcher = BackEndDispatcher.this;
            synchronized (backEndDispatcher) {
                this.lastIncomingResponse = rsp;
                BackEndDispatcher.this.notifyAll();
            }
        }
    }
}

